using System;
using Neudesic.BTSUtilities;

namespace SampleConsoleApplication
{
	/// <summary>
	/// This is a sample console application showing use of BTSServiceWindows. 
	/// Batch files have been provided
	/// </summary>
	class TestSvcWin
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{

			if (args.Length == 0)
			{
				Console.WriteLine("This sample requires the configuration file name as a parameter.");
				Console.WriteLine(@"eg: TestSvcWin ""C:\Visual Studio Projects\BTSServiceWindows\BTSServiceWindows\ServiceWindows.xml\""");
			} 
			else 
			{
				ServiceWindowManager mgr = new ServiceWindowManager(args[0]);

				mgr.LoggingEnabled = true;
				mgr.StartProcessing();

				Console.WriteLine("ServiceWindows has been started, using config file:");
				Console.WriteLine(args[0]);
				Console.WriteLine();
				Console.WriteLine("Close this window or press <enter> to exit...");
			}
			Console.Read();			
		}
	}
}
